% DEMSME.cls
%
% This is a LaTeX documentclass for contributions to
% the proceedings of the International Conference on
% Decision Making for Small and Medium-Sized Enterprises (DEMSME).
%
% Written by David Bartl
% Silesian University in Opava
% Faculty of Business Administration in Karvina
% Department of Informatics and Mathematics
% Univerzitni namesti 1934/3
% 733 40  Karvina
% Czechia
% (bartl at opf dot slu dot cz)
%

\NeedsTeXFormat {LaTeX2e}
\ProvidesClass {DEMSME}[2024/08/18 Template for DEMSME proceedings papers]

\DeclareOption {draft}  {\setlength \overfullrule {5pt}}
\DeclareOption {final}  {\setlength \overfullrule {0pt}}
\DeclareOption {oneside}{\@twosidefalse \@mparswitchfalse}
\DeclareOption {twoside}{\@twosidetrue  \@mparswitchtrue }

\ExecuteOptions {draft,oneside}
\ProcessOptions\relax

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Modify / improve some macros of plain TeX:
%	\cases
%	\matrix
%	\bordermatrix
%	\eqalign
%	\displ@y
%
%	\thinspace
%	\netghinspace
%	\enspace
%	\enskip
%	\quad
%	\qquad
%
% Supplement:
%	\listlines
%	\eqarraywithdef
%

\renewcommand* \cases [1]{%
	\left\{\,%
	\vcenter {%
		\normalbaselines
		\m@th
		\ialign {$##\hfil$&\quad##\hfil\crcr#1\crcr}%
	}%
	\right.%							% \}
}
\renewcommand* \matrix [1]{%
	\null\,%
	\vcenter {%
		\normalbaselines
		\m@th
		\ialign {%
			\hfil$##$\hfil&&\quad\hfil$##$\hfil\crcr
			\mathstrut\crcr
			\noalign {\kern-\baselineskip}%
			#1\crcr
			\mathstrut\crcr
			\noalign {\kern-\baselineskip}%
		}%
	}\,%
}
\renewcommand* \bordermatrix [1]{%
	\null\;%
	\vbox {%
		\setbox\z@ \hbox {\the\textfont\thr@@ B}%
		\dimen@ \wd\z@		% \p@renwd \wd\z@
		\normalbaselines
		\m@th
		\setbox\z@\vbox {%
			\def \cr {%
				\crcr
				\noalign {%
					\kern.66667\jot
					\global\let\cr\endline
				}%
			}%
			\ialign {%
				$##$\hfil$\mkern3.6mu$\kern\dimen@ % \p@renwd
					&$\,$\hfil$##$\hfil
					&&\quad\hfil$##$\hfil\crcr
				\omit\strut\hfil\crcr
				\noalign {\kern-\baselineskip}%
				#1\crcr
				\omit\strut\hfil\cr
			}%
		}%
		\setbox\tw@\vbox {%
			\unvcopy\z@
			\global\setbox\@ne\lastbox
		}%
		\setbox\tw@\hbox {%
			\unhbox\@ne
			\unskip
			\global\setbox\@ne\lastbox
		}%
		\setbox\tw@\hbox {$%
			\kern\wd\@ne
			\kern-\dimen@	% -\p@renwd
			\left (%
			\kern-\wd\@ne
			\global\setbox\@ne\vbox {%	% get the height
				\box\@ne		% of the first (!)
				\kern.66667\jot		% line
			}%
			\vcenter {%
				\kern-\ht\@ne		% move that up
				\unvbox\z@
				\kern-\baselineskip
			}\,%
			\right )%
		$}%
		\kern\ht\@ne				% move that down
		\box\tw@
	}%
}
\newcommand* \eqarr@ywithdef [1]{%
	\null\,%
	\vcenter {%
		\normalbaselines
		\openup\jot
		\m@th
		\ialign {\strut#1\crcr}%
	}\,%
}
\newcommand* \eqalign [1]{\eqarr@ywithdef {%
	\hfil$\displaystyle{##}$&$\displaystyle{{}##}$\hfil \crcr
	#1%
}}
\newcommand* \listlines [1]{\eqarr@ywithdef {%
	\hfil$\displaystyle{##}$\hfil \crcr
	#1%
}}
\newcommand* \eqarraywithdef [1]{%
	\eqarr@ywithdef {\ignorespaces #1}%
}
\renewcommand* \displ@y {%
	\global\dt@ptrue
	\normalbaselines
	\openup\jot
	\m@th
	\everycr {\noalign {%
		\ifdt@p
			\global\dt@pfalse
			\ifdim\prevdepth>-\@m\p@
				\vskip-\lineskiplimit
				\vskip\normallineskiplimit
			\fi
		\else
			\penalty\interdisplaylinepenalty
		\fi
	}}%
}

\expandafter \renewcommand		% Insert a space at the end
\expandafter *%				% of the definition to break
\expandafter \thinspace			% the <dimen> syntax rule!
\expandafter {%
\expandafter	\ifmmode
\expandafter		\mkern
\expandafter		\thr@@
\expandafter		m%
\expandafter		u%
\expandafter	\else
\expandafter		\kern
\expandafter		.%
\expandafter		1%
\expandafter		6%
\expandafter		6%
\expandafter		6%
\expandafter		7%
\expandafter		e%
\expandafter		m%
\expandafter	\fi
	\space
}
\expandafter \renewcommand		% Insert a space at the end
\expandafter *%				% of the definition to break
\expandafter \negthinspace		% the <dimen> syntax rule!
\expandafter {%
\expandafter	\ifmmode
\expandafter		\mkern
\expandafter		-%
\expandafter		\thr@@
\expandafter		m%
\expandafter		u%
\expandafter	\else
\expandafter		\kern
\expandafter		-%
\expandafter		.%
\expandafter		1%
\expandafter		6%
\expandafter		6%
\expandafter		6%
\expandafter		7%
\expandafter		e%
\expandafter		m%
\expandafter	\fi
	\space
}
\expandafter \renewcommand		% Insert a space at the end
\expandafter *%				% of the definition to break
\expandafter \enspace			% the <dimen> syntax rule!
\expandafter {%
\expandafter	\ifmmode
\expandafter		\mkern
\expandafter		9%
\expandafter		m%
\expandafter		u%
\expandafter	\else
\expandafter		\kern
\expandafter		.%
\expandafter		5%
\expandafter		e%
\expandafter		m%
\expandafter	\fi
	\space
}
\renewcommand* \enskip {\ifmmode \mskip 9mu\else \hskip    .5em\fi \relax }
\renewcommand* \quad   {\ifmmode \mskip18mu\else \hskip \@ne em\fi \relax }
\renewcommand* \qquad  {\ifmmode \mskip36mu\else \hskip \tw@ em\fi \relax }

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Fonts:
% Use Times New Roman
% ... inspired by the MME Proceedings class for LaTeX 2e (mmeproc.cls)
% Other font commands
%

\RequirePackage{ifxetex}
\ifxetex
	\expandafter \def \expandafter \normalsize \expandafter
		{\expandafter \protect \csname normalsize \endcsname}
	\RequirePackage {fontspec,unicode-math}
	\@ifdefinable\DEMSME@in {}
	\@ifdefinable\DEMSME@th {}
	\IfFontExistsTF {TeX Gyre Termes}{%
		\def \DEMSME@in {\setmainfont {TeX Gyre Termes}}%
		\IfFontExistsTF {TeX Gyre Termes Math}{%
			\def \DEMSME@th {\setmathfont {TeX Gyre Termes Math}}%
		}{%
			\let \DEMSME@th \@empty
		}%
	}{%
		\IfFontExistsTF {Times New Roman}{%
			\def \DEMSME@in {\setmainfont {Times New Roman}}%
		}{%
			\def \DEMSME@in {\setmainfont {Times}}%
		}%
		\let \DEMSME@th \@empty
	}
	\DEMSME@in
	\DEMSME@th
\else
	\@ifdefinable\DEMSME@MainFontPACKAGE {}
	\IfFileExists {newtxtext.sty}{%
		\def \DEMSME@MainFontPACKAGE {newtxtext,newtxmath}%
	}{%
		\IfFileExists {mathptmx.sty}{%
			\def \DEMSME@MainFontPACKAGE {mathptmx}%
		}{%
			\def \DEMSME@MainFontPACKAGE {times}%
		}%
	}
	\RequirePackage {\DEMSME@MainFontPACKAGE}
\fi

\DeclareOldFontCommand \rm {\normalfont \rmfamily \selectfont }{\mathrm}
\DeclareOldFontCommand \mit      {\the\textfont\@ne}           {\mathnormal}
\DeclareOldFontCommand \oldstyle {\the\textfont\@ne}           {\mathnormal}
\DeclareOldFontCommand \cal      {\the\textfont\tw@}           {\mathcal}
\DeclareOldFontCommand \it {\normalfont \itshape  \selectfont }{\mathit}
\DeclareOldFontCommand \sl {\normalfont \slshape  \selectfont }{}
\DeclareOldFontCommand \bf {\normalfont \bfseries \selectfont }{\mathbf}
\DeclareOldFontCommand \tt {\normalfont \ttfamily \selectfont }{\mathtt}
\DeclareOldFontCommand \sf {\normalfont \sffamily \selectfont }{\mathsf}
\DeclareOldFontCommand \sc {\normalfont \scshape  \selectfont }{}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Set sizes (font size, linespacing, etc.)
%


% \set@all@sizes ......	sets:
%	\@setfontsize -- font size and the linespacing,
%	\normallineskip, \lineskip,
%	\nulldelimiterspace, \scriptspace
%	\bigskipamount, \medskipamount, \smallskipamount,
%	\jot,
%	\abovedisplayskip, \abovedisplayshortskip,
%	\belowdisplayskip, \belowdisplayshortskip,
%	\strutbox,
%	\arraycolsep,
%	\vdots, \ddots,
%	\big, \Big, \bigg, \Bigg, \sbig, \ssbig.
% argumenty:
%	#1 ....	size name (\normalsize, \small, ...)
%	#2 ....	font size in pt
%	#3 ....	\baselineskip	= \normalbaselineskip	size
%	#4 ....	\lineskip	= \normallineskip	size
%	#5 .... \nulldelimiterspace	size
%	#6 .... \scriptspace		size
%

\@ifdefinable \@mxxiv {}
\mathchardef \@mxxiv = 1024
\newcommand* \set@all@sizes [6]{%
	\@setfontsize #1#2{#3}%
	\@tempdima #3\p@
	\@tempdimb #4\p@
	\nulldelimiterspace #5\p@
	\scriptspace        #6\p@
	\normalbaselineskip \@tempdima
	\normallineskip     \@tempdimb
	\baselineskip \normalbaselineskip
	\lineskip     \normallineskip
	\dimen@   \@tempdima
	\dimen@ii \@tempdima
	\divide \dimen@ii \thr@@
	\vdots@kern         \dimen@
	\vdots@baselineskip \dimen@ii
	\ddots@raisei   \dimen@ii
	\ddots@raiseii  \dimen@ii
	\ddots@raiseiii \dimen@ii
	\setbox\z@ \hbox {$\vdot@ \mkern\tw@ mu$}%
	\advance \vdots@kern -\@ne\lineskip
	\advance \vdots@kern -\fontdimen\@vpt\textfont\@ne
	\vdots@kern .98589\vdots@kern
	\bigskipamount   \dimen@ \@plus \dimen@ii \@minus \dimen@ii
	\dimen@   .5\dimen@
	\dimen@ii .5\dimen@ii
	\medskipamount   \dimen@ \@plus \dimen@ii \@minus \dimen@ii
	\partopsep \medskipamount
	\dimen@   .5\dimen@
	\dimen@ii .5\dimen@ii
	\smallskipamount \dimen@ \@plus \dimen@ii \@minus \dimen@ii
	\jot \dimen@
	\abovedisplayshortskip \z@ \@plus \dimen@ \@minus \thr@@\dimen@
	\abovedisplayskip      \abovedisplayshortskip
	\advance \abovedisplayskip \@tempdima
	\belowdisplayskip      \abovedisplayskip
	\belowdisplayshortskip \abovedisplayskip
	\setbox\tw@ \hbox {()}%
	\dimen@   \@tempdima
	\dimen@ii \dp\tw@
	\advance \dimen@ii .05\dimen@
	\advance \dimen@  -\dimen@ii
	\setbox\strutbox \hbox {%
		\vrule \@height \dimen@ \@depth \dimen@ii \@width \z@
	}%
	\advance \@tempdima \@tempdimb
	\advance \@tempdima \ht\z@
	\advance \@tempdima \tw@\ddots@raiseii
	\advance \@tempdima \vdots@kern
	\divide \@tempdima \@mxxiv
	\multiply \@tempdima \wd\z@
	\@tempdimb \fontdimen\@vipt\textfont\tw@
	\arraycolsep .5\@tempdimb
	\@tempdimb \tw@\@tempdimb
	\setbox\z@ \hbox {$a$}%
	\advance \@tempdimb \wd\z@
	\setbox\z@ \hbox {$\mathinner{\ldotp\ldotp\ldotp}$}%
	\advance \@tempdimb \wd\z@
	\divide \@tempdimb \@mxxiv
	\divide \@tempdima \@tempdimb
	\advance \ddots@raisei  -\@tempdima
	\advance \ddots@raiseiii \@tempdima
	\ddots@kern \vdots@kern
	\advance \ddots@kern \ddots@raisei
	\expandafter \let \expandafter \@let@token \the\textfont\thr@@
	\dimen@ii \fontdimen22\textfont\tw@
	\set@dimen@Bbigg \dimen@big   {\char\z@\char\@ne}%
	\set@dimen@Bbigg \dimen@Big   {\char\sixt@@n\char17}%
	\set@dimen@Bbigg \dimen@bigg  {\char18\char19}%
	\set@dimen@Bbigg \dimen@Bigg  {\char32!}%
	\set@dimen@Ssbig \dimen@sbig  \textfont   \scriptfont
	\set@dimen@Ssbig \dimen@ssbig \scriptfont \scriptscriptfont
}
\newcommand* \set@dimen@Bbigg [2]{%
	\setbox\z@ \hbox {\@let@token #2}%
	\dimen@ \ht\z@
	\advance \dimen@ \dp\z@
	#1\dimen@ii
	\advance #1.5\dimen@
}
\newcommand* \set@dimen@Ssbig [3]{%
	\setbox\z@ \hbox {\the#2\z@ ()}%
	\dimen@ \ht\z@
	\advance \dimen@ \dp\z@
	#1\fontdimen22#3\tw@
	\advance #1.5\dimen@
}

\@ifdefinable \vdots@baselineskip {}
\@ifdefinable \vdots@kern {}
\newskip  \vdots@baselineskip
\newdimen \vdots@kern
\renewcommand* \vdots {%
	\vbox {%
		\baselineskip \vdots@baselineskip
		\lineskiplimit \z@
		\kern \vdots@kern
		\vdot@
		\vdot@
		\vdot@
	}%
}
\@ifdefinable \ddots@kern {}
\@ifdefinable \ddots@raisei   {}
\@ifdefinable \ddots@raiseii  {}
\@ifdefinable \ddots@raiseiii {}
\newdimen \ddots@kern
\newdimen \ddots@raisei
\newdimen \ddots@raiseii
\newdimen \ddots@raiseiii
\renewcommand* \ddots {%
	\mathinner {%
		\mkern \@ne mu%
		\raise \ddots@raiseiii \vbox {%
			\kern \ddots@kern
			\vdot@
		}%
		\mkern \tw@ mu%
		\raise \ddots@raiseii \vdot@
		\mkern \tw@ mu%
		\raise \ddots@raisei \vdot@
		\mkern \@ne mu%
	}%
}
\newcommand* \vdot@ {\hbox {$.$}}

\@ifdefinable \dimen@big   {}
\@ifdefinable \dimen@Big   {}
\@ifdefinable \dimen@bigg  {}
\@ifdefinable \dimen@Bigg  {}
\@ifdefinable \dimen@sbig  {}
\@ifdefinable \dimen@ssbig {}
\newdimen \dimen@big
\newdimen \dimen@Big
\newdimen \dimen@bigg
\newdimen \dimen@Bigg
\newdimen \dimen@sbig
\newdimen \dimen@ssbig
\renewcommand* \big   {\@big@ \@empty            \dimen@big  }
\renewcommand* \Big   {\@big@ \@empty            \dimen@Big  }
\renewcommand* \bigg  {\@big@ \@empty            \dimen@bigg }
\renewcommand* \Bigg  {\@big@ \@empty            \dimen@Bigg }
\newcommand*   \sbig  {\@big@ \scriptstyle       \dimen@sbig }
\newcommand*   \ssbig {\@big@ \scriptscriptstyle \dimen@ssbig}
\newcommand* \sbigl  {\mathopen \sbig }	% \bigl, \bigr, \bigm, ... can be used
\newcommand* \sbigm  {\mathrel  \sbig }	% in \textstyle or \displaystyle only.
\newcommand* \sbigr  {\mathclose\sbig }	% These \sbigl, \sbigr, \sbigm, ...
\newcommand* \ssbigl {\mathopen \ssbig}	% are for use in \scriptstyle
\newcommand* \ssbigm {\mathrel  \ssbig}	%  only.  And these are for
\newcommand* \ssbigr {\mathclose\ssbig}	% \scriptscriptstyle only.
\newcommand* \@big@ [3]{{\hbox{$%		% \@big@:
	#1%					% #1 -- math style
	\left #3%				% #3 -- the delimiter
		\vbox to#2{}%			% #2 -- height (dimen)
	\right.%
	\n@space
$}}}

\DeclareMathSizes {10.95}{10.95}{7.5}{6.5}
\renewcommand*	\normalsize	{\set@all@sizes \normalsize
		\@xipt {12.6974375}\@ne {1.314}{.5475}%
}

\DeclareMathSizes {8}{8}{5.5}{4.5}
\newcommand*	\footnotesize	{\set@all@sizes \footnotesize
		\@viiipt {9.2345}\@ne {.96}{.4}%
}

\DeclareMathSizes {9}{9}{6}{5}
\newcommand*	\bibliographysize	{\set@all@sizes \bibliographysize
		\@ixpt {10.3888125}\@ne {1.08}{.45}%
}

\DeclareMathSizes {12}{12}{8}{7}
\newcommand*	\author@size	{\set@all@sizes \author@size
		\@xiipt {13.85175}\@ne {1.44}{.6}%
}

\DeclareMathSizes {14.4}{14.4}{10.5}{8.5}
\newcommand*	\title@size	{\set@all@sizes \title@size
		\@xivpt {16.160375}\@ne {1.728}{.72}%
}

%delimiterfactor    = 901
%delimitershortfall = 5pt

%lineskiplimit       = 0pt
%normallineskiplimit = 0pt

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Page construction
%

\topskip      = .36cm
\splittopskip = \topskip
\parskip = 0pt
\parsep  = \parskip

\maxdepth  = 12.6974375pt
\divide \maxdepth by 3		% \maxdepth =  1/3 \normalbaselineskip ?
%@maxdepth = \maxdepth		% done by \begin {document}


\@ifdefinable \bibliographyparindent {}	% == the \parindent
\newdimen     \bibliographyparindent
\@ifdefinable \bibliographyparsep    {}	% == 1/3 \normalbaselineskip
\newskip      \bibliographyparsep	% in \bibliographysize
\bibliographyparindent = 1.25cm
\parindent             = \bibliographyparindent
\bibliographyparsep    = 3.4629375pt plus 1.1543125pt minus 1.1543125pt

\paperwidth     = 210mm		% A4 paper
\paperheight    = 297mm

\oddsidemargin  =  25mm
\textwidth      = 160mm
\marginparsep   =   5mm
\marginparwidth =  15mm
\evensidemargin =  25mm

\marginparpush  =  12.6974375pt	% == \normalbaselineskip in \normalsize

\topmargin      =   1.25cm
\headheight     =  10.95pt	% heading font size
\headsep        =   1.25cm
\advance \headsep by -\headheight
\textheight     = 247mm
\footskip       =   1.25cm

\voffset = -1truein
\hoffset = -1truein

\pagenumbering {arabic}

\clubpenalty         =10000
\widowpenalty        =10000
%displaywidowpenalty =   50
\predisplaypenalty   =  150
%postdisplaypenalty  =    0
%@clubpenalty        = \clubpenalty	% done by \begin {document}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% List environments
%   ---	enumerate
%   ---	itemize
%

%renewcommand* \theenumi   {\@arabic \c@enumi  }
\renewcommand* \theenumii  {\@alph %(
				     \c@enumii)}
\renewcommand* \theenumiii {\@arabic \c@enumiii}
\renewcommand* \theenumiv  {\@arabic \c@enumiv }
\newcommand* \labelenumi   {\theenumi  .}
\newcommand* \labelenumii  {\theenumii  }
\newcommand* \labelenumiii {\theenumiii.}
\newcommand* \labelenumiv  {\theenumiv .}
%renewcommand*  \p@enumi   {}
\renewcommand*  \p@enumii  {%p@enumi
				       \labelenumi   }
\renewcommand*  \p@enumiii {\p@enumii  \labelenumii .}
\renewcommand*  \p@enumiv  {\p@enumiii \labelenumiii }

\newcommand* \labelitemi   {$\m@th \bullet$}
\newcommand* \labelitemii  {$\m@th \circ$}
\newcommand* \labelitemiii {$\m@th \bullet$}
\newcommand* \labelitemiv  {$\m@th \bullet$}

\leftmargini   =2\bibliographyparindent	% 2.5cm
\leftmarginii  = \bibliographyparindent	% 1.25cm
\leftmarginiii = \bibliographyparindent
\leftmarginiv  = \bibliographyparindent
\leftmarginv   = \bibliographyparindent
\leftmarginvi  = \bibliographyparindent
%rightmargin   = 0pt		% reset in every \list
\topsep        = 0pt
%partopsep     = 0pt		% see above
%parsep        = \parskip	% see above
\itemsep       = 0pt
%itemindent    = 0pt			% reset in every \list
%listparindent = \bibliographyparindent	% reset in every \list
\labelwidth    = 0pt
%labelsep      = 5mm		% see \@trivlist below
\@ifdefinable \labelsep@ {}
\@ifdefinable \labels@p  {}
\newdimen \labelsep@
\newdimen \labels@p
\labelsep@     = 5mm
\labels@p      = 7mm
\newcommand* \@listi  {\leftmargin\leftmargini  }
\newcommand* \@listii {\leftmargin\leftmarginii }
\newcommand* \@listiii{\leftmargin\leftmarginiii}
\newcommand* \@listiv {\leftmargin\leftmarginiv }
\newcommand* \@listv  {\leftmargin\leftmarginv  }
\newcommand* \@listvi {\leftmargin\leftmarginvi }
\@ifdefinable \@trivlist@ori {}
\@ifdefinable \enumerate@ori {}
\@ifdefinable \itemize@@@ori {}
\let \@trivlist@ori = \@trivlist
\let \enumerate@ori = \enumerate
\let \itemize@@@ori = \itemize
\renewcommand* \@mklab [1]{\llap {#1}\hfil}
\newcommand*   \@mkl@b [1]{\rlap {#1}\hfil}
\renewcommand* \@trivlist {%
	\@trivlist@ori
	\labelsep \labelsep@
}
\renewcommand* \enumerate {%
	\@enumdepth \@listdepth
	\enumerate@ori
	\parindent \bibliographyparindent
	\labelsep \labels@p
	\let \makelabel \@mkl@b
}
\renewcommand* \itemize {%
	\@itemdepth \@listdepth
	\itemize@@@ori
	\parindent \bibliographyparindent
	\let \makelabel \@mklab
}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Penalties for \(no)pagebreak and \(no)linebreak.
%

\@lowpenalty  =  51
\@medpenalty  = 151
\@highpenalty = 301

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Page layout: headers, etc.
%   ---	\pagestyle {empty}
% \raggedbottom ... to emulate Word's behaviour
%

\pagestyle {empty}
\raggedbottom

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% New environments
%   ---	steps
%   ---	description
%   ---	quote
%   ---	quotation
%

\newcommand* \leftmargin@romannumeral {%
	\csname leftmargin\romannumeral\@listdepth\endcsname
}
\@ifdefinable \if@insteps {}
\newif \if@insteps	% \@instepsfalse
\@ifdefinable \list@ori {}
\let \list@ori = \list
\renewcommand* \list {%
	\if@insteps
		\@instepsfalse
		\dimen@ \leftmargin@romannumeral
		\advance \@totalleftmargin \dimen@
		\advance \linewidth -\dimen@
	\fi
	\list@ori
}

\newenvironment* {steps}{%
	\@itemdepth \@listdepth
	\ifnum \@enumdepth >\thr@@
		\@toodeep
	\else
		\partopsep \z@skip
		\topsep  \medskipamount
		\itemsep \medskipamount
		\advance \@enumdepth \@ne
		\edef \@enumctr {enum\romannumeral\@enumdepth}%
		\expandafter
		\list	\csname label\@enumctr\endcsname
			{%
				\usecounter \@enumctr
				\advance \leftmargin -\leftmargin@romannumeral
				\listparindent \bibliographyparindent
				\let \makelabel \stepslabel
				\@instepstrue
			}%
	\fi
}{%
	\endlist
}
\newcommand* \stepslabel [1]{%
	\kern \labelsep@
	\normalfont \scshape \selectfont
	Step~#1\ \ %
	\kern -\labelsep@
}

\newenvironment* {description}{%
	\list   {}%
		{%
			\itemindent -\bibliographyparindent
			\listparindent \bibliographyparindent
			\let \makelabel \descriptionlabel
		}%
}{%
	\endlist
}
\newcommand* \descriptionlabel [1]{%
	\kern \labelsep@
	\normalfont \bfseries \selectfont
	#1\/%
	\kern -\labelsep@
}
\newenvironment* {quote}{%
	\list   {}%
		{%
			\rightmargin \bibliographyparindent
			\listparindent \bibliographyparindent
		}%
		\item \relax
}{%
	\endlist
}
\newenvironment* {quotation}{\quote}{\endquote}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Settings for the tabular a array environments.
% Setting  for the tabbing environment.
%

%arraycolsep     = 0pt	% see above
\tabcolsep       = 0pt
\arrayrulewidth  =.73pt
\doublerulesep   = 2pt

\tabbingsep      = 0pt

\renewcommand* \hline {\noalign {\iffalse}\fi \futurelet \@let@token \hl@ne }
\newcommand*   \hl@ne {%
	\ifx \hline \@let@token
		\expandafter \@hl@ne
	\else
		\expandafter \@hl@n@
		\expandafter \@empty
	\fi
}
\@ifdefinable \@hl@ne {}
\def          \@hl@ne \hline {\@hl@n@ \tw@}
\newcommand*  \@hl@n@ [1]{\hrule \@height #1\arrayrulewidth \iffalse{\fi}}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Settings for footnotes.
% Settings for the minipage environment.
% Settings for floating environments.
%

\footnotesep = 9.2345pt		% == \normalbaselineskip in \footnotesize
\setbox2 = \hbox {\normalfont \footnotesize \selectfont ()}
\dimen2 = \dp2
\advance \dimen2 by .05\footnotesep	% .. see \set@all@sizes
\advance \footnotesep by -\dimen2	% == \ht\strutbox in \footnotesize
\skip\footins = 15.6974375pt		% == \bigskipamount in \normalsize
		plus 4.232479167pt	% + 3pt ... the height of \footnoterule
		minus 4.232479167pt
\count\footins = 1000			% magnification factor (1 to 1)
\dimen\footins = 33\skip\footins	% 33\normalbaselineskip in \normalsize

\skip\@mpfootins = \skip\footins

\floatsep     = 25.394875pt		% == 2\bigskipamount in \normalsize
		plus 8.464958333pt minus 8.464958333pt
\textfloatsep = 25.394875pt		% == 2\bigskipamount in \normalsize
		plus 8.464958333pt minus 8.464958333pt
\intextsep    = 25.394875pt		% == 2\bigskipamount in \normalsize
		plus 8.464958333pt minus 8.464958333pt
\dblfloatsep     = \floatsep
\dbltextfloatsep = \textfloatsep
\@fptop       = 0pt
\@fpsep       = 25.394875pt		% == 2\bigskipamount in \normalsize
		plus 8.464958333pt minus 8.464958333pt
\@fpbot       = 0pt plus 1fil
\@dblfptop    = \@fptop
\@dblfpsep    = \@fpsep
\@dblfpbot    = \@fpbot
\renewcommand* \topfraction         {.9}	\setcounter {topnumber}   {9}
\renewcommand* \bottomfraction      {.3}	\setcounter {bottomnumber}{9}
\renewcommand* \textfraction        {.1}	\setcounter {totalnumber}{99}
\renewcommand* \floatpagefraction   {.5}
\renewcommand* \dbltopfraction      {.9}	\setcounter {dbltopnumber}{9}
\renewcommand* \dblfloatpagefraction{.5}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Settings for \fbox and \framebox.
% Settings for two-column setting.
%

\fboxsep  = 3pt
\fboxrule =.4pt

\columnsep     = 1cm
\columnseprule = 0pt

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Markup commands:
%   ---	\title
%   ---	\author
%   ---	\address
%   ---	\begin {abstract}
%   ---	...
%   --- \end {abstract}
%   ---	\keywords
%   ---	\classification
%   ---	\section
%   ---	\subsection
%   ---	\subsubsection
%   ---	\begin {thebibliography} + \bibitem + \@cite + \@cite@ofmt + \newblock
%   ---	...
%   --- \end {thebibliography}
%

\renewcommand* \title [1]{%
	\cleardoublepage
	\begingroup
		\normalfont \title@size \bfseries \selectfont
		\topskip .46cm%
		\rightskip \@flushglue
		\noindent \uppercase {\ignorespaces #1}\par
	\endgroup
	\nobreak
}

\renewcommand* \author [1]{%
	\begingroup
		\normalfont \author@size \bfseries \selectfont
		\bigskip
		\rightskip \@flushglue
		\noindent \ignorespaces #1\par
	\endgroup
	\nobreak
}

\newcommand* \address [1]{%
	\begingroup
		\normalfont \normalsize \selectfont
		\rightskip \@flushglue
		\noindent \ignorespaces #1\par
	\endgroup
}

\newenvironment* {abstract}{%
	\begingroup
		\normalfont \normalsize \itshape \bfseries \selectfont
		\bigskip
		\noindent \abstractname\par
		\nobreak
		\mdseries \selectfont
		\noindent
		\ignorespaces
}{%
		\par
	\endgroup
	\bigskip
}

\newcommand \keywords@classification [2]{%
	\begingroup
		\normalfont \normalsize \itshape \bfseries \selectfont
		\noindent #1: \mdseries \selectfont \ignorespaces #2\par
	\endgroup
}

\newcommand* \keywords {%
	\keywords@classification \keywordsname
}

\newcommand* \classification {\futurelet \@let@token \cl@ssification }
\newcommand* \cl@ssification {%
	\ifx [\@let@token						%]
		\expandafter \cl@ss@fication
	\else
		\expandafter \cl@ss@f@cation \expandafter \jelname
	\fi
}
\@ifdefinable \cl@ss@fication {}
\def          \cl@ss@fication [#1]{\cl@ss@f@cation {#1}}
\newcommand*  \cl@ss@f@cation [1]{%
	\keywords@classification {#1 \classificationname}%
}

\@ifdefinable\@sub@sub@section@ {}
\def         \@sub@sub@section@*{}
\newcommand* \@sub@sub@section  [1]{%
	\ifx *\@let@token
		\@tempswafalse
		\expandafter \expandafter \expandafter #1%
		\expandafter \@sub@sub@section@
	\else
		\@tempswatrue
		\expandafter #1%
	\fi
}

\newcommand* \@sub@sub@section@body [3]{%
	\normalfont \normalsize #1\selectfont
	\rightskip \@flushglue
	\interlinepenalty \@M
	\hangindent #2%
	\noindent
	\if@tempswa
		\setbox\z@ \hbox {#3}%
		\ifdim \wd\z@ <#2%
			\setbox\z@ \hb@xt@ #2{%
				\unhbox\z@ \hfil
			}%
		\fi
		\box\z@
	\fi
	\ignorespaces
}

\newcommand* \nobreak@nobreaktrue@everypar {%
	\nobreak
	\@nobreaktrue
	\everypar {%
		\@nobreakfalse
		\everypar {}%
	}%
}

\@ifdefinable     \section@indent {}
\newdimen         \section@indent
\section@indent = .5cm
\newcommand*  \pre@section@skip {%	% == .6 * 2\normalbaselineskip
	\vskip 15.257\p@    \@plus 5.085666667\p@ \@minus 5.085666667\p@
}
\newcommand* \post@section@skip {%	% == .4 * 2\normalbaselineskip
	\vskip 10.137875\p@ \@plus 3.379291667\p@ \@minus 3.379291667\p@
}					% in \normalsize
\newcounter       {section}
%renewcommand* \thesection {\@arabic \c@section }
\newcommand*      \section {\futurelet \@let@token \@section }
\newcommand*     \@section {\@sub@sub@section \@@section }
\newcommand*    \@@section [1]{%
	\if@tempswa
		\refstepcounter {section}%
	\fi
	\vskip -\lastskip
	\if@nobreak
		\allowbreak
		\everypar {}%
	\fi
	\pre@section@skip
	\begingroup
		\@sub@sub@section@body \bfseries \section@indent
		{\thesection.}#1\par
	\endgroup
	\nobreak@nobreaktrue@everypar
	\post@section@skip
}

\@ifdefinable     \subsection@indent {}
\newdimen         \subsection@indent
\subsection@indent = .8cm
\@ifdefinable \pre@subsection@skip {}	% == .6\normalbaselineskip
\newskip      \pre@subsection@skip	% in \normalsize
\pre@subsection@skip = 7.6285pt       plus 2.542833333pt    minus 2.542833333pt
\newcommand* \post@subsection@skip {%	% == .4\normalbaselineskip
	\vskip         5.0689375\p@ \@plus 1.689645833\p@ \@minus 1.689645833\p@
}					% in \normalsize
\newcounter       {subsection}[section]
\renewcommand* \thesubsection {\thesection.\@arabic \c@subsection }
\newcommand*      \subsection {\futurelet \@let@token \@subsection }
\newcommand*     \@subsection {\@sub@sub@section \@@subsection }
\newcommand*    \@@subsection [1]{%
	\if@tempswa
		\refstepcounter {subsection}%
	\fi
	\@sub@subsection@prebody
		\@sub@sub@section@body \bfseries \subsection@indent
		\thesubsection #1%
	\@sub@subsection@postbody
}

\@ifdefinable     \subsubsection@indent {}
\newdimen         \subsubsection@indent
\subsubsection@indent = 1.09cm
\newcounter       {subsubsection}[subsection]
\renewcommand* \thesubsubsection {\thesubsection.\@arabic \c@subsubsection }
\newcommand*      \subsubsection {\futurelet \@let@token \@subsubsection }
\newcommand*     \@subsubsection {\@sub@sub@section \@@subsubsection }
\newcommand*    \@@subsubsection [1]{%
	\if@tempswa
		\refstepcounter {subsubsection}%
	\fi
	\@sub@subsection@prebody
		\@sub@sub@section@body \itshape \subsubsection@indent
		\thesubsubsection #1%
	\@sub@subsection@postbody
}

\newcommand* \@sub@subsection@prebody {%
	\skip@ \lastskip
	\if@nobreak
		\vskip -\skip@
		\allowbreak
		\vskip
		\ifdim \skip@ <\pre@subsection@skip
			\pre@subsection@skip
		\else
			\skip@
		\fi
		\everypar {}%
	\else
		\ifdim \skip@ <\pre@subsection@skip
			\advance \skip@ -\pre@subsection@skip
			\vskip -\skip@
		\fi
	\fi
	\begingroup
}
\newcommand* \@sub@subsection@postbody {%
		\par
	\endgroup
	\nobreak@nobreaktrue@everypar
	\post@subsection@skip
}

\newenvironment* {thebibliography} [1]{%
	\section* {\refname}%
	\normalfont \bibliographysize \selectfont
	\parsep \bibliographyparsep
	\partopsep \z@skip
	\frenchspacing
	\leftmargini \bibliographyparindent
	\list   {}%
		{%
			\itemindent -\bibliographyparindent
		}%
		\sloppy
		\interlinepenalty \@M
}{%
		\renewcommand*\@noitemerr {\@latex@warning
			{Empty `thebibliography' environment}}%
	\endlist
}
\renewcommand* \bibitem {\futurelet \@let@token \b@bitem }
\newcommand*   \b@bitem {%
	\ifx [\@let@token						%]
		\expandafter \b@bitem@
	\else
		\expandafter \b@b@tem@
	\fi
}
\@ifdefinable \b@bitem@ {}
\def          \b@bitem@ [#1]{\@tempswatrue \b@bitem@@ {#1}}
\newcommand*  \b@b@tem@     {\@tempswafalse\b@bitem@@ \@empty}
\newcommand*  \b@bitem@@ [2]{%
	\item
	\if@filesw
		{%
			\let \protect \noexpand
			\immediate \write\@auxout {\string\bibcite {#2}%
				{\if@tempswa #1\else #2\fi}}%
		}
	\fi
	\ignorespaces
}
\renewcommand* \@cite      [2]{{#1\if@tempswa , #2\fi}}
%renewcommand* \@cite@ofmt    {}
\let           \@cite@ofmt = \@empty
\newcommand* \newblock {%
	\hskip .111111em\@plus .333333em\@minus -.074074em %
}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Prikazy pro tvorbu novych prostredi:
%   ---	newtheorem
%   ---	newdefinition
%   ---	newremark
%   ---	newproof
%

\newcommand* \@eaeaea {\expandafter \expandafter \expandafter }
\newcommand* \@boldfacetrue  {\let \if@boldface \iftrue }
\newcommand* \@boldfacefalse {\let \if@boldface \iffalse}

\newcommand* \@boldfacetrue@tempswatrue  {\@boldfacetrue \@tempswatrue  }
\newcommand* \@boldfacetrue@tempswafalse {\@boldfacetrue \@tempswafalse }

\renewcommand* \newtheorem    {\@boldfacetrue@tempswatrue  \new@thm@def@rem }
\newcommand*   \newdefinition {\@boldfacetrue@tempswafalse \new@thm@def@rem }
\newcommand*   \newremark     {\@boldfacefalse             \new@thm@def@rem }

\newcommand* \new@thm@def@rem [1]{%
	\def \next {#1}%
	\new@thm@def@rem@@
}
\newcommand* \new@thm@def@rem@   {\afterassignment       \new@thm@def@rem@@
							 \let\@let@token= }
\newcommand* \new@thm@def@rem@@  {\futurelet \@let@token \new@thm@def@rem@@@ }
\expandafter \newcommand
\expandafter *%
\expandafter \new@thm@def@rem@@@
\expandafter {%
	\expandafter \ifcat \space \noexpand \@let@token
		\expandafter \new@thm@def@rem@
	\else
		\ifx [\@let@token					% ]
			\@eaeaea \new@thm@def@remA
		\else
			\@eaeaea \new@thm@def@remB
		\fi
	\fi
}
\newcommand* \new@thm@def@rem@AB [1]{%
	\if@boldface	%   ---	zacatek tucne
		\if@tempswa	%   ---	pak sklonene
			\@eaeaea #1\expandafter \expandafter \expandafter
						\@boldfacetrue@tempswatrue
		\else		%   ---	pak vzprimene
			\@eaeaea #1\expandafter \expandafter \expandafter
						\@boldfacetrue@tempswafalse
		\fi
	\else		%   ---	zacatek kurzivou, pak vzprimene
		\expandafter #1\expandafter \@boldfacefalse
	\fi
}
\newcommand* \new@thm@def@remA  {\new@thm@def@rem@AB \new@thm@def@remAA }
\@ifdefinable\new@thm@def@remAA {}
\def         \new@thm@def@remAA #1[#2]#3{%
	\expandafter \newenvironment
	\expandafter *%
	\expandafter {\next}{%
		#1%
		\@thm {#2}{#3}%
	}{%
		\global\advance \@listdepth \@ne
		\endlist
	}%
}
\newcommand* \new@thm@def@remB  {\new@thm@def@rem@AB \new@thm@def@remBB }
\newcommand* \new@thm@def@remBB [2]{%
	\@eaeaea                               \newenvironment
	\expandafter \expandafter \expandafter *%
	\expandafter \expandafter \expandafter {%
	\expandafter                           \next
	\expandafter                           }%
	\expandafter                           {%
		\expandafter #1%
		\expandafter \@thm
		\expandafter {\next}{#2}%
	}{%
		\global\advance \@listdepth \@ne
		\endlist
	}%
	%new@thm@def@remB@@
	\expandafter \newcounter \expandafter {\next}\relax
}
%%\newcommand* \new@thm@def@remB@   {\afterassignment       \new@thm@def@remB@@
%%							  \let\@let@token= }
%%\newcommand* \new@thm@def@remB@@  {\futurelet \@let@token \new@thm@def@remB@@@ }
%%\expandafter \newcommand
%%\expandafter *%
%%\expandafter \new@thm@def@remB@@@
%%\expandafter {%
%%	\expandafter \ifcat \space \noexpand \@let@token
%%		\expandafter \new@thm@def@remB@
%%	\else
%%		\ifx [\@let@token					% ]
%%			\@eaeaea \new@thm@def@remC
%%		\else
%%			\new@thm@def@remD
%%		\fi
%%	\fi
%%}
%%%renewcommand* \@thmcountersep {.}
%%\@ifdefinable\new@thm@def@remC {}
%%\def         \new@thm@def@remC [#1]{%
%%	\expandafter \newcounter
%%	\expandafter {\next}[#1]%
%%	\expandafter \def
%%	\expandafter \@let@token
%%	\expandafter {\csname the#1\endcsname }%
%%	\@eaeaea                               \def
%%	\expandafter \expandafter \expandafter \@let@token
%%	\expandafter \expandafter \expandafter {%
%%	\expandafter                           \@let@token \@thmcountersep }%
%%	\@eaeaea                               \expandafter
%%	\expandafter \expandafter \expandafter \def
%%	\expandafter \expandafter \expandafter \expandafter
%%	\expandafter \expandafter \expandafter \@let@token
%%	\expandafter \expandafter \expandafter \expandafter
%%	\expandafter \expandafter \expandafter {%
%%	\expandafter \expandafter \expandafter \@let@token \csname the\next
%%								\endcsname }%
%%	\@eaeaea     \def
%%	\expandafter \csname
%%	\expandafter t%
%%	\expandafter h%
%%	\expandafter e%
%%	\expandafter \next
%%	\expandafter \endcsname
%%	\expandafter {\@let@token}%
%%}
%%\newcommand* \new@thm@def@remD {%
%%	\expandafter \newcounter \expandafter {\next}%
%%}

\renewcommand* \@thm [2]{%
	\list   {%
		}{%
			\leftmargin \z@
			\listparindent \bibliographyparindent
		}%
		\global\advance \@listdepth \m@ne
		\item \relax
		\refstepcounter {#1}%
		\normalfont
		\bgroup
			\if@boldface
				\bfseries
			\else
				\itshape
			\fi
			\selectfont
			#2~\csname the#1\endcsname
			\@thm@@
}
\newcommand* \@thm@   {\afterassignment       \@thm@@  \let\@let@token= }
\newcommand* \@thm@@  {\futurelet \@let@token \@thm@@@ }
\expandafter \newcommand
\expandafter *%
\expandafter \@thm@@@
\expandafter {%
	\expandafter \ifcat \space \noexpand \@let@token
		\expandafter \@thm@
	\else
		\ifx [\@let@token					% ]
			\@eaeaea \@thmA
		\else
			\@thmB
		\fi
	\fi
}
\@ifdefinable\@thmA {}
\def         \@thmA [#1]{\/ \newblock {\normalfont \selectfont (#1)}%
		\@thmB
}
\newcommand* \@thmB {. \newblock
		\egroup
		\if@boldface
			\if@tempswa
				\itshape
			\fi
		\fi
		\selectfont
		\ignorespaces
}

\newcommand*   \newproof [3]{%
	\newenvironment*{#1}{\@prf {#2}}{\@endprf {#3}}%
}

\newcommand* \@prf [1]{%
	\list   {%
		}{%
			\leftmargin \z@
			\listparindent \bibliographyparindent
		}%
		\item \relax
		\bgroup
			\normalfont \itshape \selectfont
			#1%
			\@prf@@
}

\newcommand* \@prf@   {\afterassignment       \@prf@@  \let\@let@token= }
\newcommand* \@prf@@  {\futurelet \@let@token \@prf@@@ }
\expandafter \newcommand
\expandafter *%
\expandafter \@prf@@@
\expandafter {%
	\expandafter \ifcat \space \noexpand \@let@token
		\expandafter \@prf@
	\else
		\ifx [\@let@token					% ]
			\@eaeaea \@prfA
		\else
			\@prfB
		\fi
	\fi
}
\@ifdefinable\@prfA {}
\def         \@prfA [#1]{\/ \newblock {\normalfont \selectfont #1}%
		\@prfB
}
\newcommand* \@prfB     {. \newblock
		\egroup
		\ignorespaces
}
\newcommand* \@endprf [1]{%
		\parfillskip \z@skip
		\ifhmode
			\finalhyphendemerits \z@
			\unskip
			\nobreak
			\hfil
			\penalty \@m
			\quad
			\null
			\nobreak
		\fi
		\hfil
		{#1}%
		\par
	\endlist
}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Floating environments
%   ---	figure
%   ---	table
%   ---	\@makecaption
%   ---	footnotes
%

\newcommand* \leftrightpar@skip {%
	\leftskip  \@flushglue
	\rightskip \@flushglue
	\parfillskip \z@skip
}

\newcounter        {figure}
%renewcommand*  \thefigure {\@arabic \c@figure}
\newcommand*   \fps@figure {tbp}
\newcommand* \ftype@figure {1}
\newcommand*   \ext@figure {lof}
\newcommand*  \fnum@figure {\figurename~\thefigure}
\newenvironment*   {figure}{%
	\@float    {figure}%
	\leftrightpar@skip
}{%
	\end@float
}
\newenvironment*   {figure*}{%
	\@dblfloat {figure}%
	\leftrightpar@skip
}{%
	\end@dblfloat
}

\newcounter        {table}
%renewcommand*  \thetable {\@arabic \c@table}
\newcommand*   \fps@table {tbp}
\newcommand* \ftype@table {2}
\newcommand*   \ext@table {lot}
\newcommand*  \fnum@table {\tablename~\thetable}
\newenvironment*   {table}{%
	\@float    {table}%
	\leftrightpar@skip
}{%
	\end@float
}
\newenvironment*   {table*}{%
	\@dblfloat {table}%
	\leftrightpar@skip
}{%
	\end@dblfloat
}

\newcommand \@makecaption [2]{%		% \long \def --> without *
	\setbox\z@ \vbox {%
		\leftrightpar@skip
		\normalfont \normalsize \bfseries \selectfont
		\noindent \strut #1.\mdseries \selectfont \ \ %
		#2\nobreak\hskip\z@skip\strut
	}%
	\ifdim \ht\z@ >\ht\strutbox
		{%
			\leftskip  \bibliographyparindent
			\rightskip \bibliographyparindent
			\parindent \bibliographyparindent
			\normalfont \normalsize \bfseries \selectfont
			\noindent \strut #1.\mdseries \selectfont \ \ %
			#2\nobreak\hskip\z@skip\strut\par
		}%
	\else
		\unvbox\z@
	\fi
	\nointerlineskip
}
\newcommand \captionbelow [1]{%		% \long \def --> without *
	\@@par
	\setbox\z@ \vbox {%
		\leftrightpar@skip
		\normalfont \normalsize \selectfont
		\noindent \strut #1\strut
	}%
	\ifdim \ht\z@ >\ht\strutbox
		{%
			\nointerlineskip
			\leftskip  \bibliographyparindent
			\rightskip \bibliographyparindent
			\parindent \bibliographyparindent
			\parfillskip \@flushglue
			\normalfont \normalsize \selectfont
			\noindent \strut #1\nobreak\hskip\z@skip\strut\par
		}%
	\else
		\unvbox\z@
	\fi
}
\newcommand* \T [1]{@{\tabskip \z@ \@plus #1fil\relax }}

\renewcommand* \footnoterule {%
	\kern -3\p@		% so that the rule/line passes through the
	\hrule \@width 2in	% centre of the letter "x" in \normalsize
	\kern  2.6\p@		% the \hrule is .4pt high
}
\newcommand* \@makefntext    {%
%newcommand  \@makefntext [1]{%		% \long \def --> without * }
	\normalfont \footnotesize \selectfont
	\noindent \@makefnmark \ %#1%
}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Names in English
%

\newcommand* \abstractname       {Abstract}
\newcommand* \keywordsname       {Keywords}
\newcommand* \jelname            {JEL}
\newcommand* \classificationname {Classification}
\newcommand* \refname            {References}
\newcommand* \figurename         {Figure}
\newcommand* \tablename          {Table}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%% --- END --- %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
